% model_parameters.m
% 
% generates model parameters
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions\');
addpath('Utilities\')
addpath('Data\')

% -- Load Data -- %
load_data;

% Discount Factor
beta = 0.96;

% Value added Shares in Gross Output
gamma_j = mean(gamma(:,:),1);    % 1 x nS, all sectors

% Capital Shares in Value Added  
alpha_j = [0.1223,0.3432,0.4041,0.8500,0.4262];

% Depreciation Rates
% psix_mean = pctile(psiX,.2)
psix_mean = mean(psiX);
delta_j = ((psix_mean./alpha_j)*((1/beta)-1))./(1-(psix_mean./alpha_j));     % 1 x nS, all sectors

% -- Investment Goods -- %
% Creating zeta_x
x_ces = 2:3;
omega_temp = mean(omega(:,:,:),3);
rho_x  = sum(omega_temp(x_ces,:));

zeta_x = omega_temp(:,:)./(1-rho_x);
zeta_x(x_ces,:) = []; % zeta_x is dimension 3x5, it omits Durable Goods and IPP Services

% -- Materials -- %
% Creating zeta_m
m_ces = 2:3;
phi_temp = mean(phi(:,:,:),3);
rho_m = sum(phi_temp(m_ces,:));

zeta_m = phi_temp(:,:)./(1-rho_m);
zeta_m(m_ces,:) = []; % zeta_m is dimension 3x5, it omits Durable Goods and IPP Services

% -- Preferences -- %
i_ces = 4:5;
theta_mean = mean(theta(:,:),1);
s_c = sum(theta_mean(:,1:3));            

% Creating zeta_c
zeta_c = theta_mean(:,:)/s_c;
zeta_c(:,i_ces) = [];
zeta_c = zeta_c';

save([matdir 'observable_parameters.mat'],...
    'beta','gamma_j','alpha_j','delta_j','rho_x','zeta_x','rho_m',...
    'zeta_m','zeta_c','s_c','nq')


